VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmLIVDemo 
   Caption         =   "Laser Diode L-I-V Sweep Test Demo"
   ClientHeight    =   10830
   ClientLeft      =   2835
   ClientTop       =   1200
   ClientWidth     =   9975
   LinkTopic       =   "Form1"
   ScaleHeight     =   10830
   ScaleWidth      =   9975
   Begin VB.Frame Frame6 
      Caption         =   "24xx settings"
      Height          =   975
      Left            =   6120
      TabIndex        =   56
      Top             =   8760
      Width           =   3615
      Begin VB.TextBox txt24xxVProt 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1320
         TabIndex        =   59
         Text            =   "2"
         Top             =   600
         Width           =   495
      End
      Begin VB.TextBox txt24xxRange 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   120
         TabIndex        =   57
         Text            =   "20"
         Top             =   600
         Width           =   495
      End
      Begin VB.Label Label26 
         Caption         =   "V Protection"
         Height          =   255
         Left            =   1080
         TabIndex        =   60
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label25 
         Caption         =   "V Range"
         Height          =   255
         Left            =   120
         TabIndex        =   58
         Top             =   360
         Width           =   855
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "GPIB Addresses"
      Height          =   975
      Left            =   120
      TabIndex        =   47
      Top             =   8760
      Width           =   5775
      Begin VB.TextBox txt2510GpibAddr 
         Height          =   285
         Left            =   4080
         TabIndex        =   50
         Text            =   "10"
         Top             =   600
         Width           =   375
      End
      Begin VB.TextBox txt2500GpibAddr 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2160
         TabIndex        =   49
         Text            =   "25"
         Top             =   600
         Width           =   375
      End
      Begin VB.TextBox txt24xxGpibAddr 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   120
         TabIndex        =   48
         Text            =   "24"
         Top             =   600
         Width           =   375
      End
      Begin VB.Label Label22 
         Caption         =   "2510"
         Height          =   255
         Left            =   4080
         TabIndex        =   53
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label21 
         Caption         =   "2500"
         Height          =   255
         Left            =   2160
         TabIndex        =   52
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label20 
         Caption         =   "24xx"
         Height          =   255
         Left            =   120
         TabIndex        =   51
         Top             =   360
         Width           =   615
      End
   End
   Begin VB.TextBox txtComments 
      Height          =   735
      Left            =   240
      TabIndex        =   45
      Top             =   10200
      Width           =   9375
   End
   Begin VB.Frame Frame4 
      Caption         =   "Detector Bias Voltage and Current Range"
      Height          =   1335
      Left            =   6120
      TabIndex        =   36
      Top             =   7440
      Width           =   3615
      Begin VB.TextBox textN2CurrRange 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2760
         TabIndex        =   42
         Text            =   "0.01"
         Top             =   840
         Width           =   735
      End
      Begin VB.TextBox textN2Bias 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1920
         TabIndex        =   41
         Text            =   "0"
         Top             =   840
         Width           =   735
      End
      Begin VB.TextBox textN1CurrRange 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1080
         TabIndex        =   40
         Text            =   "0.001"
         Top             =   840
         Width           =   735
      End
      Begin VB.TextBox textN1Bias 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   0
         EndProperty
         Height          =   285
         Left            =   120
         TabIndex        =   37
         Text            =   "0"
         Top             =   840
         Width           =   855
      End
      Begin VB.Label Label24 
         Alignment       =   2  'Center
         Caption         =   "Ch 2"
         Height          =   255
         Left            =   1920
         TabIndex        =   55
         Top             =   360
         Width           =   1575
      End
      Begin VB.Label Label23 
         Alignment       =   2  'Center
         Caption         =   "Ch 1"
         Height          =   255
         Left            =   120
         TabIndex        =   54
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label19 
         Alignment       =   2  'Center
         Caption         =   "BD Rng"
         Height          =   255
         Left            =   2760
         TabIndex        =   44
         Top             =   600
         Width           =   735
      End
      Begin VB.Label Label18 
         Alignment       =   2  'Center
         Caption         =   "BD Bias V"
         Height          =   255
         Left            =   1920
         TabIndex        =   43
         Top             =   600
         Width           =   735
      End
      Begin VB.Label Label16 
         Alignment       =   2  'Center
         Caption         =   "FD Rng"
         Height          =   255
         Left            =   1080
         TabIndex        =   39
         Top             =   600
         Width           =   615
      End
      Begin VB.Label Label15 
         Alignment       =   2  'Center
         Caption         =   "FD Bias V"
         Height          =   255
         Left            =   240
         TabIndex        =   38
         Top             =   600
         Width           =   735
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Module Temperature Control:  2510 TEC SourceMeter"
      Height          =   1095
      Left            =   120
      TabIndex        =   29
      Top             =   7440
      Width           =   5775
      Begin VB.TextBox txtTECRes 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2760
         TabIndex        =   34
         Top             =   600
         Width           =   735
      End
      Begin VB.ComboBox comboTempOnOff 
         Height          =   315
         ItemData        =   "System LIV Sweep RevA01.frx":0000
         Left            =   4800
         List            =   "System LIV Sweep RevA01.frx":000A
         TabIndex        =   33
         Text            =   "OFF"
         Top             =   600
         Width           =   735
      End
      Begin VB.ComboBox comboTempSetPoint 
         Height          =   315
         ItemData        =   "System LIV Sweep RevA01.frx":0017
         Left            =   240
         List            =   "System LIV Sweep RevA01.frx":002A
         TabIndex        =   32
         Text            =   "25"
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label14 
         Caption         =   "TEC Resistance"
         Height          =   255
         Left            =   2520
         TabIndex        =   35
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label13 
         Caption         =   "Deg. Celsius"
         Height          =   255
         Left            =   1320
         TabIndex        =   31
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label Label12 
         Caption         =   "Set Point"
         Height          =   255
         Left            =   240
         TabIndex        =   30
         Top             =   360
         Width           =   855
      End
   End
   Begin VB.OptionButton EnableTest 
      Caption         =   "Enable Pass/Fail"
      Height          =   255
      Left            =   6240
      TabIndex        =   28
      Top             =   6240
      Width           =   1575
   End
   Begin VB.TextBox textPassFail 
      Appearance      =   0  'Flat
      BackColor       =   &H0000FF00&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   24
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00008000&
      Height          =   555
      Left            =   6240
      TabIndex        =   27
      Text            =   "PASS"
      Top             =   6600
      Width           =   1575
   End
   Begin VB.Frame Frame2 
      Caption         =   "Laser Diode L-I-V Sweep Test Demo"
      Height          =   255
      Left            =   240
      TabIndex        =   18
      Top             =   1080
      Width           =   3495
   End
   Begin VB.Frame Frame1 
      Caption         =   "Test Statistics"
      Height          =   1335
      Left            =   120
      TabIndex        =   15
      Top             =   6030
      Width           =   5775
      Begin VB.TextBox textSteps 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4560
         TabIndex        =   25
         Text            =   "100"
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkStddev 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3480
         TabIndex        =   23
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkMinima 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   2400
         TabIndex        =   21
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkMaxima 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   1320
         TabIndex        =   19
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textThresoldCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   17
         Top             =   840
         Width           =   975
      End
      Begin VB.Label Label11 
         Alignment       =   2  'Center
         Caption         =   "Number of Steps"
         Height          =   495
         Left            =   4680
         TabIndex        =   26
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label10 
         Alignment       =   2  'Center
         Caption         =   "Kink Stddev"
         Height          =   375
         Left            =   3600
         TabIndex        =   24
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label9 
         Alignment       =   2  'Center
         Caption         =   "Kink Minima"
         Height          =   375
         Left            =   2520
         TabIndex        =   22
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label8 
         Alignment       =   2  'Center
         Caption         =   "Kink Maxima"
         Height          =   375
         Left            =   1440
         TabIndex        =   20
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Threshold Current"
         Height          =   375
         Left            =   240
         TabIndex        =   16
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Frame frameParameters 
      Caption         =   "L-I-V Sweep Test Parameters"
      Height          =   1215
      Left            =   4080
      TabIndex        =   4
      Top             =   120
      Width           =   5655
      Begin VB.TextBox textStepCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4560
         TabIndex        =   14
         Text            =   "0.001"
         Top             =   720
         Width           =   735
      End
      Begin VB.TextBox textStopCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   3480
         TabIndex        =   13
         Text            =   "0.05"
         Top             =   720
         Width           =   855
      End
      Begin VB.TextBox textStartCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2400
         TabIndex        =   12
         Text            =   "0.001"
         Top             =   720
         Width           =   855
      End
      Begin VB.TextBox txtSourceDelay 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1200
         TabIndex        =   8
         Text            =   "0.003"
         Top             =   720
         Width           =   975
      End
      Begin VB.ComboBox comboNPLC 
         Height          =   315
         ItemData        =   "System LIV Sweep RevA01.frx":0042
         Left            =   240
         List            =   "System LIV Sweep RevA01.frx":0065
         TabIndex        =   6
         Text            =   "1.0"
         Top             =   720
         Width           =   735
      End
      Begin VB.Label Label5 
         Alignment       =   2  'Center
         Caption         =   "Step Current (A)"
         Height          =   375
         Left            =   4560
         TabIndex        =   11
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label4 
         Alignment       =   2  'Center
         Caption         =   "Stop Current (A)"
         Height          =   375
         Left            =   3480
         TabIndex        =   10
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label3 
         Alignment       =   2  'Center
         Caption         =   "Start Current (A)"
         Height          =   495
         Left            =   2400
         TabIndex        =   9
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Source Delay"
         Height          =   255
         Left            =   1200
         TabIndex        =   7
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Caption         =   "NPLC"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   360
         Width           =   855
      End
   End
   Begin MSChart20Lib.MSChart MSChart1 
      Height          =   4695
      Left            =   0
      OleObjectBlob   =   "System LIV Sweep RevA01.frx":009D
      TabIndex        =   3
      Top             =   1320
      Width           =   9975
   End
   Begin VB.CommandButton buttonRunTest 
      Caption         =   "L-I-V Sweep Test"
      Height          =   375
      Left            =   8280
      TabIndex        =   2
      Top             =   6840
      Width           =   1455
   End
   Begin VB.TextBox textTime 
      Alignment       =   1  'Right Justify
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   8280
      TabIndex        =   0
      Top             =   6360
      Width           =   1455
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   360
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label Label17 
      Caption         =   "Enter optional comments that will stored in the data file:"
      Height          =   255
      Left            =   240
      TabIndex        =   46
      Top             =   9960
      Width           =   3975
   End
   Begin VB.Image Image1 
      Height          =   735
      Left            =   240
      Picture         =   "System LIV Sweep RevA01.frx":DDE8
      Top             =   120
      Width           =   3510
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Total Test Time"
      Height          =   255
      Left            =   8280
      TabIndex        =   1
      Top             =   6000
      Width           =   1455
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuSaveAs 
         Caption         =   "Save &As"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmLIVDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*******************************************************************
'***                                                             ***
'***             Laser Diode L-I-V Sweep Test Demo               ***
'***                                                             ***
'*******************************************************************
'
'This demo is intended to be an example of how to use a 2420 and two
'2400s to perform an L-I-V sweep test on a laser diode module.
'Modifications to this program may be required to test attain the
'required kink detection sensitivity.
'
'Note that very little error checking and no error handling is used
'in this program.  In a production environment, error checking and
'handling would be a must.

Option Explicit

Dim intStatus As Integer        'GPIB status
Dim intLength As Integer        'Length of GPIB input string
Dim intSteps As Integer         'Steps required given start, stop
                                'and step

Dim strData As String           'GPIB input string

Dim dblSourceDelay As Double    'Source Delay for 2420
Dim dblStartCurrent As Double   'Starting Current Sweep Level
Dim dblStopCurrent As Double    'Final Current Sweep Level
Dim dblStepCurrent As Double    'Current Step for Sweep

Dim dblArray(1 To 6, 1 To 1010) As Double   'dblArray holds all the raw
                                            'data and calculated test
                                            'results.  It also feed
                                            'the chart object.

Const intKth2420% = 24       '2420 is GPIB Address 24
Const intKth2500% = 25       '2500 is GPIB Address 25
Const intKth2510% = 10       '2510 is GPIB Address 10

Const intLDVoltage% = 1     'These constants are used to improve
Const intLDCurrent% = 2     'readability of the code by naming
Const intBSDCurrent% = 3    'each of the rows in dblArray.
Const intPDCurrent% = 4
Const int2ndDofPDC% = 5
Const int1stDofPDC% = 6

'******************************************************************
'Reset Instruments

'This subroutine resets all three instruments from a power on state
'or from almost any error condition.

'******************************************************************
Private Sub ResetInstruments()

textTime.ForeColor = &HFF0000   'set text color to green
textTime.Text = "Testing..."    'display 'Testing...' status

'Reset 2420
Call send(intKth2420, "*rst", intStatus)                    'issue reset
Call send(intKth2420, ":trace:feed:cont never", intStatus)  'turn off trace
Call send(intKth2420, ":trace:clear", intStatus)            'clear trace buffer
Call send(intKth2420, "*cls", intStatus)                    'clear status register

'Reset 2500
Call send(intKth2500, "*rst", intStatus)                   'issue reset
Call send(intKth2500, ":trace:feed:cont never", intStatus) 'turn off trace
Call send(intKth2500, ":trace:clear", intStatus)           'clear trace buffer
Call send(intKth2500, "*cls", intStatus)                   'clear status register


End Sub

'******************************************************************
'Setup first 2500

'Setup 2500 to measure the photodiode current through the front
'facet external photodiode and back facet internal photodiode.

'******************************************************************
Private Sub Setup2500()

' General instrument configuration
Call send(intKth2500, ":form:elem curr1,curr2", intStatus)         'output only current readings
Call send(intKth2500, ":form:data sre;bord swap", intStatus)       'binary format
'Call send(intKth2500, ":syst:key 16", intStatus)                   ' toggle display to show both channels
Call send(intKth2500, ":syst:azer off", intStatus)                 'Disable Auto-zero (which speeds up sweep)
'Call send(intKth2500, ":disp:enab off", intStatus)                 'Disable Display (which speeds up sweep slightly)

' *******   Configure Channel 1 of 2500   **********

' Setup sense circuitry for current measure range
Call send(intKth2500, ":sens1:curr:nplc " & comboNPLC, intStatus)   'set NPLC using input Param.
Call send(intKth2500, ":sens1:curr:rang " & textN1CurrRange, intStatus)       '20mA range
'Call send(intKth2500, ":SENS1:CURR:RANG:AUTO ON", intStatus)        'auto-range

'Setup source to bias the front facet photodiode.
Call send(intKth2500, ":sour1:volt:range 10", intStatus)      'set range to 10V
If textN1Bias > 10 Then: textN1Bias = 10
If textN1Bias < -10 Then: textN1Bias = -10
Call send(intKth2500, ":sour1:volt " & textN1Bias, intStatus) 'set bias output
Call send(intKth2500, ":sour1:delay 0", intStatus)     'set source delay to zero
Call send(intKth2500, ":sour1:gcon 1", intStatus)       'enable ground connect relay

' *******   Configure Channel 2 of 2500   **********

' Setup sense circuitry for 20mA range
Call send(intKth2500, ":sens2:curr:nplc " & comboNPLC, intStatus)   'set NPLC using input Param.
Call send(intKth2500, ":sens2:curr:rang " & textN2CurrRange, intStatus)       '20mA range
'Call send(intKth2500, ":SENS2:CURR:RANG:AUTO ON", intStatus)        'auto-range

'Setup source to bias the photodiode with 5V.
Call send(intKth2500, ":sour2:volt:range 10", intStatus)      'set range to 10V
If textN2Bias > 10 Then: textN2Bias = 10
If textN2Bias < -10 Then: textN2Bias = -10
Call send(intKth2500, ":sour2:volt " & textN2Bias, intStatus) 'set bias output
Call send(intKth2500, ":sour2:delay 0", intStatus)     'set source delay to zero
Call send(intKth2500, ":sour2:gcon 1", intStatus)       'enable ground connect relay


'Setup Trigger Model:  Bypass both arm layers and use trigger
'layer to synch with trigger from 2420.

Call send(intKth2500, ":arm:sour imm", intStatus)             'bypass arm layer 1
Call send(intKth2500, ":arm:coun 1", intStatus)               'set scan count
Call send(intKth2500, ":arm:dir acc", intStatus)              'wait for trigger event
Call send(intKth2500, ":trig:clear", intStatus)               'clear triggers
Call send(intKth2500, ":trig:sour tlink", intStatus)          'use trigger link
Call send(intKth2500, ":trig:ilin 2", intStatus)              'input trigger on line 2
Call send(intKth2500, ":trig:olin 1", intStatus)              'output trigger on line 1
Call send(intKth2500, ":trig:input sense", intStatus)         'wait for input trigger before
Call send(intKth2500, ":trig:outp sense", intStatus)          'output trigger after setting
Call send(intKth2500, ":trig:dir acceptor", intStatus)        'do not bypass on first pass

'Call send(intKth2500, ":trac:feed calc3,calc4", intStatus)


End Sub



'******************************************************************
'Setup 2420

'The 2420 will be setup to sweep from start (lower level) to stop
'(higher level) current in steps defined by the sweep parameters.
'The parameters be checked before Setup2420 is called.

'The 2420 also masters the trigger link for the sweep.

'******************************************************************
Private Sub Setup2420()



'Setup SourceMeter(tm) system commands:

Call send(intKth2420, ":syst:beep:stat off", intStatus)         'disable beeper
Call send(intKth2420, ":syst:azer:stat off", intStatus)         'disable auto zero for speed
Call send(intKth2420, ":syst:rsen 1", intStatus)                'enable four-wire measurements

'Call send(intKth2420, ":display:enable off", intStatus)        'disable display

Call send(intKth2420, ":rout:term rear", intStatus)             'use rear terminals

'The source is configured for the sweep from textStartCurrent to textStopCurrent
'in steps defined by textStepCurrent.  The sweep will use the best fixed range
'to prevent the inherent dicontinuities of range changing from being seen by the
'analysis code as kink.  The source delay is also set to accomidate the cable and
'DUT capacitive loading.

Call send(intKth2420, ":sour:func curr", intStatus)                     'source current
Call send(intKth2420, ":sour:curr:start " & textStartCurrent, intStatus) 'set start (min.)
Call send(intKth2420, ":sour:curr:stop " & textStopCurrent, intStatus)  'set stop (max.)
Call send(intKth2420, ":sour:curr:step " & textStepCurrent, intStatus)  'set step
Call send(intKth2420, ":sour:curr:mode sweep", intStatus)               'enable sweep mode
Call send(intKth2420, ":sour:swe:rang best", intStatus)                 'use best fixed range
Call send(intKth2420, ":sour:swe:spac lin", intStatus)                  'select linear sweep
Call send(intKth2420, ":sour:del " & txtSourceDelay, intStatus)        'set source delay



'The 2420 will source current and measure the forward junction voltage
'across the laser diode.  Both current and voltage will be passed to
'the analysis portion of the code.

Call send(intKth2420, ":sens:volt:nplc " & comboNPLC, intStatus) 'set NPLC per input param.
Call send(intKth2420, ":sens:func:conc off", intStatus)          'turn off concurrent meas.
Call send(intKth2420, ":sens:func 'volt'", intStatus)            'sense voltage (V forward of LD)
Call send(intKth2420, ":sens:volt:prot " + txt24xxVProt, intStatus)    'limit output voltage to txt24xxVProt
Call send(intKth2420, ":sens:volt:range " + txt24xxRange, intStatus)

Call send(intKth2420, ":form:elem volt,curr", intStatus)         'readback both voltage and current

Call send(intKth2420, ":format:data sre;bord swap", intStatus)   'binary format

Call send(intKth2420, ":stat:meas:enab 512", intStatus)         'mask "buffer full" byte
Call send(intKth2420, "*sre 1", intStatus)                      'mask "measurement summary bit" for SRQ


'Trigger layer is used to keep track of triggers from the front facet
'photodetector meter.  The trigger count will be set later.
Call send(intKth2420, ":arm:sour imm", intStatus)              'bypass arm layer
Call send(intKth2420, ":arm:count inf", intStatus)

Call send(intKth2420, ":trig:clear", intStatus)                 'clear triggers
Call send(intKth2420, ":trig:sour tlink", intStatus)            'use trigger link
Call send(intKth2420, ":trig:ilin 1", intStatus)                'input trigger on line 1
Call send(intKth2420, ":trig:olin 2", intStatus)                'output trigger on line 2
Call send(intKth2420, ":trig:input source", intStatus)          'wait for input trigger before
                                                                'changing source
Call send(intKth2420, ":trig:outp del", intStatus)              'output trigger after soaking device
                                                                'new source current value
Call send(intKth2420, ":trig:dir source", intStatus)            'bypass first input trigger
Call send(intKth2420, ":trig:delay 0", intStatus)               'set trigger delay to 0mS

End Sub

'******************************************************************
'ExecuteSweep:

'

'******************************************************************
Private Sub ExecuteSweep()

Dim poll As Integer
Dim longTempTime As Long
Dim longTempTime2 As Long
Dim i As Integer
Dim intMaxPoint As Integer
Dim intMinPoint As Integer
Dim intStrPointer As Integer
Dim dblMaxima As Double
Dim dblMinima As Double
Dim dblSum As Double
Dim dblMean As Double
Dim dblStddev As Double
Dim byteArray!(1 To 5000)
Dim status&, length&

'Begin sweep by setting up trigger counts, trace length, and
'enabling the trace subsystems.
    
longTempTime = Timer    'grab a time stamp before starting test
    
Call send(intKth2500, ":trig:count " & textSteps, intStatus)  'set trigger count
'Call send(intKth2500, ":trace:feed:cont never", intStatus)    'turn off trace control
'Call send(intKth2500, ":trace:cle", intStatus)                'clear trace logic
'Call send(intKth2500, ":trace:poin " & textSteps, intStatus)  'set number of measurments to record
'Call send(intKth2500, ":trace:feed sens", intStatus)          'feed trace memory with measurments
'Call send(intKth2500, ":trace:feed:cont next", intStatus)     'enable trace logic for recording
    
Call send(intKth2420, "*cls", intStatus)                        'clear all registers
Call send(intKth2420, ":arm:count 1", intStatus)                'set arm count to 1
Call send(intKth2420, ":trig:count " & textSteps, intStatus)    'set trigger count
Call send(intKth2420, ":trace:feed:cont never", intStatus)      'disable trace logic
Call send(intKth2420, ":trace:clear", intStatus)                'clear trace logic
Call send(intKth2420, ":trace:points " & textSteps, intStatus)  'set number of measurments to record
Call send(intKth2420, ":trace:feed sens", intStatus)            'feed trace memory with measurments
Call send(intKth2420, ":trace:feed:control next", intStatus)    'enable trace logic



'Turn outputs on, take units out of idle state, trigger sweep, wait
'for completion, and issue trace data queries:

'clear comments for dual 2400n configuration
Call send(intKth2500, ":outp1:stat on", intStatus)    'turn on front facet diode bias
Call send(intKth2500, ":outp2:stat on", intStatus)    'turn on back facet diode bias
Call send(intKth2420, ":outp:stat on", intStatus)     'turn on LD drive output
Call send(intKth2500, ":init", intStatus)             'take front facet meter out of idle
Call send(intKth2420, ":init", intStatus)               'trigger the sweep...
   
Do
    DoEvents        'the 2420 will issue an srq once the buffer is full and testing complete
Loop Until (srq And 1)
Call spoll(intKth2420, poll, intStatus)

textTime.Text = (Timer - longTempTime) & " Seconds"             'calculate elapse time

Call send(intKth2420, ":outp:stat off", intStatus)          'turn off 2420
Call send(intKth2500, ":outp1:stat off", intStatus)         'turn off front facet bias
Call send(intKth2500, ":outp2:stat off", intStatus)         'turn off back facet bias

Call send(intKth2420, ":trace:data?", intStatus)       'query 2420 to empty buffer
Call send(intKth2500, ":fetch?", intStatus)            'query PD meter for latest readings
  
    
'Enter laser diode voltage and current trace and pass to dblArray().
'Note that the 2420 is read first because it prepares the output table
'faster than the 2500.  In this way, the 2500 have more time to
'perpare the output table before the code attempts to read the trace
'buffer.
    
Call transmit("UNT UNL MLA TALK" + Str$(intKth2420), intStatus)   ' Address 2400 to talk
If (intStatus And 8) Then Stop                                    ' Check for timeout
Call IErarray(byteArray!(1), 2, length, status)                   ' Read "#0" from binary string
If (intStatus And 8) Then Stop                                    ' Check for timeout
Call IErarray(byteArray!(1), 2 * intSteps * 4 + 1, length, status) ' Enter rdgs
If (intStatus And 8) Then Stop                                    ' Check for timeout
If length& < 2 * intSteps * 4 Then Stop                           ' Verify length of string
Call transmit("UNT UNL", intStatus)                               ' Stop talking
If (intStatus And 8) Then Stop                                    ' Check for timeout

For i = 1 To intSteps                                         'loop once for each step
    dblArray(intLDVoltage, i) = byteArray(i * 2 - 1) 'pass voltage value to dblArray()
    dblArray(intLDCurrent, i) = byteArray(i * 2)     'pass current value to dblArray()
Next i


' Enter front facet current (channel 1) and back facet (channel 2) trace and perform
' analysis to find threshold current value and location.

Call transmit("UNT UNL MLA TALK" + Str$(intKth2500), intStatus)   ' Address 2500 to talk
If (intStatus And 8) Then Stop                                      ' Check for timeout
Call IErarray(byteArray!(1), 2, length, status)                     ' Read "#0" from binary string
If (intStatus And 8) Then Stop                                      ' Check for timeout
Call IErarray(byteArray!(1), 2 * intSteps * 4 + 1, length, status)    ' Enter rdgs from both channels
If (intStatus And 8) Then Stop                                      ' Check for timeout
If length& < intSteps * 4 Then Stop                                 ' Verify length of string
Call transmit("UNT UNL", intStatus)                                 ' Stop talking
If (intStatus And 8) Then Stop                                      ' Check for timeout
        
dblMaxima = 0                                                       'clear Maxima
For i = 1 To intSteps                                      'loop once for each sweep step
    dblArray(intPDCurrent, i) = 250 * Abs(byteArray(i * 2 - 1)) 'pass channel 1 (front facet) to dblArray() (scale to fit graph)
    dblArray(intBSDCurrent, i) = 850 * byteArray(i * 2) 'pass channel 2 (back facet) to dblArray() (scale to fit graph)
    If i <> 1 Then                                         'if not the first point, calculate Ld/Id
        dblArray(int1stDofPDC, i) = 40 * (dblArray(intPDCurrent, i) - dblArray(intPDCurrent, i - 1))
    End If                                                          'and record value in dblArray()
    If i > 2 Then                                          'if beyond second point calculate Ld2/I2d
        dblArray(int2ndDofPDC, i) = 40 * (0.05 * dblArray(int1stDofPDC, i) - 0.05 * dblArray(int1stDofPDC, i - 1))
        If dblArray(int2ndDofPDC, i) > dblMaxima Then      'look for first maxima
            dblMaxima = dblArray(int2ndDofPDC, i)          'record current at maxima
            intMaxPoint = i                                'record location of maxima
        End If
    End If
Next i
textThresoldCurrent = Int(1000 * dblArray(intLDCurrent, intMaxPoint)) / 1000   'display the current threshold)/1000

DoEvents                                                            'update display




'Find the Mean, Stddev, Maxima, and Minima of the d2L/dI2:

dblSum = 0              'clear variables
dblMaxima = 0
dblMinima = 0

For i = (intMaxPoint + 3) To intSteps - 1                'loop thru values of d2L/dI2
                                                                  'after beyond threshold current
    If dblArray(int2ndDofPDC, i) > dblMaxima Then        'Find Maxima
        dblMaxima = dblArray(int2ndDofPDC, i)
        intMaxPoint = i
    End If
    
    If dblArray(int2ndDofPDC, i) < dblMinima Then        'Find Minima
        dblMinima = dblArray(int2ndDofPDC, i)
        intMinPoint = i
    End If
    
    dblSum = dblSum + dblArray(int2ndDofPDC, i)          'sum all the points (used for mean)
Next i

If Abs(intSteps - intMaxPoint) = 0 Then
    dblMean = 999
Else
    dblMean = dblSum / (intSteps - intMaxPoint)                       'calculate mean from sum
End If

dblSum = 0
For i = (intMaxPoint + 3) To intSteps                    'loop thru values again!
    dblSum = dblSum + (dblArray(int2ndDofPDC, i) - dblMean) ^ 2  'calculate sum of differences
Next i

If Abs(intSteps - intMaxPoint) = 0 Then
    dblStddev = 999
Else
    dblStddev = Sqr(dblSum / (intSteps - intMaxPoint))                'calculate Standard Deviation
End If

textKinkMaxima.Text = Int(1000 * dblArray(int2ndDofPDC, intMaxPoint)) / 1000    'display maxima

If intMinPoint <> 0 Then
    textKinkMinima.Text = Int(1000 * dblArray(int2ndDofPDC, intMinPoint)) / 1000    'display minima
Else
    textKinkMinima.Text = ""
End If

textKinkStddev.Text = Int(1000 * dblStddev) / 1000                              'display Stddev
DoEvents                                                                        'update display



'If the Pass/Fail test is enabled, compare values and set flag:

If EnableTest = True Then                             'if test is enabled
    If (dblMinima + 1.5 * dblStddev) < 0 Then         'if minima is less than -3*sigma => set fail
        textPassFail = "Fail"
        textPassFail.ForeColor = &H8000000A
        textPassFail.BackColor = &HFF&
    ElseIf (dblMaxima - 3 * dblStddev) > 0 Then       'if maxima is more than 3*sigma => set fail
        textPassFail = "Fail"
        textPassFail.ForeColor = &H8000000A
        textPassFail.BackColor = &HFF&
    Else                                              'else set pass
        textPassFail = "Pass"
        textPassFail.ForeColor = &H8000&
        textPassFail.BackColor = &HFF00&
    End If
End If                                              'if test is disabled
EnableTest = False                                  'disable test (default)
DoEvents                                            'update display



    
Open "c:\data.csv" For Output As #1
For i = 1 To intSteps
    strData = dblArray(intLDVoltage, i) & ","
    strData = strData & dblArray(intLDCurrent, i) & ","
    strData = strData & dblArray(intPDCurrent, i) / 1000 & ","  ' divide by scaling factor to save raw data
    strData = strData & dblArray(intBSDCurrent, i) / 1000
    Print #1, strData
Next i
Close #1

'Calculate total test and analysis time and display

DoEvents                                                        'update display

End Sub

'******************************************************************
'buttonRunTest_Click:

'The sweep has been triggered by the operator.  This sub initializes
'variable, checks input parameters, resets and programs the
'the instruments, triggers the sweep, collects the data, and analyzes
'the data for statitics and Pass/Fail condition (if enabled.)

'******************************************************************
Private Sub buttonRunTest_Click()

Dim i As Integer

Form_Load                   'init variables, etc
Check_Sweep_Parameters      'check input paramters
ResetInstruments            'reset all instruments
Setup2500                 'setup PD meter
Setup2420                   'setup current sweep
ExecuteSweep                'trigger sweep and analyze data
ChartData                   'output results to the chart object
Open "c:\temp.dat" For Output As 1
For i = 1 To intSteps
    Write #1, CStr(dblArray(int2ndDofPDC, i))
Next i
Close #1
End Sub

'******************************************************************
'ChartData:

'Update the chart object with latest data.

'******************************************************************
Private Sub ChartData()

MSChart1.ColumnCount = intSteps     'scale x axis of chart
MSChart1.ChartData = dblArray       'enter lastest data points
MSChart1.ColumnCount = intSteps     'correct for stray points in
                                    'dblArray()

Label_Chart                         're label legend

DoEvents    'update display

End Sub

'******************************************************************
'comboTempOnOff_Change:

'Setup 2510 to using input from combo boxes to control temp. of module

'******************************************************************
Private Sub comboTempOnOff_Click()

If comboTempOnOff.Text = "ON" Then
    
    Call send(intKth2510, "*rst", intStatus)
    Call send(intKth2510, ":sens:curr:prot:lev 1.0", intStatus)
    Call send(intKth2510, ":sens:temp:tran ther", intStatus)
    Call send(intKth2510, ":sens:temp:curr:auto on", intStatus)
    Call send(intKth2510, ":sens:temp:ther:range 1e4", intStatus)
    Call send(intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, intStatus)
    Call send(intKth2510, ":outp on", intStatus)
    Call send(intKth2510, ":meas:res:ac?", intStatus)
    Call enter(strData, 100, intLength, intKth2510, intStatus)
    txtTECRes.Text = strData
    Call send(intKth2510, ":outp on", intStatus)

Else

    Call send(intKth2510, "*rst", intStatus)
    
End If

End Sub

Private Sub comboTempSetPoint_Click()

    Call send(intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, intStatus)

End Sub

'******************************************************************
'Form_Load:

'Perform initializations of variables and display objects.

'******************************************************************
Private Sub Form_Load()
Dim i As Integer



'Clear the data array before updating the chart so that default
'psuedo noise is cleared from the chart display.

For i = 1 To 1000
    dblArray(intLDVoltage, i) = 0
    dblArray(intLDCurrent, i) = 0
    dblArray(intBSDCurrent, i) = 0
    dblArray(intPDCurrent, i) = 0
    dblArray(int2ndDofPDC, i) = 0
    dblArray(int1stDofPDC, i) = 0
Next i

MSChart1.ChartData = dblArray   'Feed chart with zeros

Label_Chart                     'fix legend



'Show system ready message...

textTime.ForeColor = &HC000&
textTime.Text = "System Ready"



'Hide Pass/Fail message by making foreground and background
'match form background color.

textPassFail = ""
textPassFail.ForeColor = &H8000000A
textPassFail.BackColor = &H8000000B



'Clear the test statistics displays

textThresoldCurrent = ""
textKinkMaxima = ""
textKinkMinima = ""
textKinkStddev = ""

'Format Chart attributes
'Increase line width of each series
MSChart1.Plot.SeriesCollection(intLDVoltage).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intLDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intPDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intBSDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int2ndDofPDC).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int1stDofPDC).Pen.Width = 25   'change line width

'Change background of chart to white (default= formbackground (=grey))
MSChart1.Backdrop.Fill.Style = VtFillStyleBrush
MSChart1.Backdrop.Fill.Brush.Style = VtBrushStyleSolid
MSChart1.Backdrop.Fill.Brush.FillColor.Set 255, 255, 255


Call initialize(21, 0)  'initialize the GPIB card

DoEvents        'update display

End Sub

'******************************************************************
'Label_Chart:

'This sub puts the correct labels in the legend of the chart.

'******************************************************************
Private Sub Label_Chart()

MSChart1.Row = 1                    'address row
MSChart1.RowLabel = "LD Voltage"    'caption row
MSChart1.Row = 2
MSChart1.RowLabel = "LD Current"
MSChart1.Row = 3
MSChart1.RowLabel = "Back Facet Current"
MSChart1.Row = 4
MSChart1.RowLabel = "Front PD Current"
MSChart1.Row = 5
MSChart1.RowLabel = "(dL)2/d(I2)"
MSChart1.Row = 6
MSChart1.RowLabel = "dL/dI"

'Label Y axes
'MSChart1.Plot.Axis(VtChAxisIdY, 1).AxisTitle.Text = "Det. Current + Arb. Units for dL/dI"
'MSChart1.Plot.Axis(VtChAxisIdY2, 1).AxisTitle.VtFont.Size = 12
'MSChart1.Plot.Axis(VtChAxisIdY2, 1).AxisTitle.Text = "LD Voltage + Arb Units for dL2/dI2"
'MSChart1.Plot.Axis(VtChAxisIdY, 1).AxisTitle.VtFont.Size = 12

'Increase line width of each series
MSChart1.Plot.SeriesCollection(intLDVoltage).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intLDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intBSDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intPDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int2ndDofPDC).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int1stDofPDC).Pen.Width = 25   'change line width

'Change background of chart to white (default= formbackground (=grey))
MSChart1.Backdrop.Fill.Style = VtFillStyleBrush
MSChart1.Backdrop.Fill.Brush.Style = VtBrushStyleSolid
MSChart1.Backdrop.Fill.Brush.FillColor.Set 255, 255, 255

DoEvents    'update display

End Sub

'******************************************************************
'Check_Sweep_Parameters:

'This code examines the sweep input parameters and adjust those that
'will cause conflicts in the instruments or in the program.  This
'program assumes that all current sweeps will be from lower values of
'current to higher values of current.

'******************************************************************
Private Sub Check_Sweep_Parameters()



'Confine dblSourceDelay to between 0 and 20mS.  Negative source delays
'will cause the 2420 to generate an error during programming.  Delays
'in excess of 20mS are not needed because the total capacitance of
'the cabling and laser diode will be less than a few hundred pico Farads.

dblSourceDelay = Val(txtSourceDelay)
If dblSourceDelay < 0 Then dblSourceDelay = 0
If dblSourceDelay > 0.02 Then dblSourceDelay = 0.02
txtSourceDelay.Text = dblSourceDelay



'The starting values or lowest value in the sweep must be greater than
'zero to prevent a negative going voltage spike from damaging the
'laser diode.  (In an effort to maximize input bandwidth of the laser
'diode the capacitance must kept to a minimum.  For this reason, no
'clamping diode is used to prevent negative going voltages from causing
'damage.)  Also, the routine that analyzes the laser diode must be able
'to detect the threshold current to be able to correctly analyze the
'kinks.  For this reason, if the pass/fail test is enabled, the starting
'current sweep value must be much less than the current threshold of
'about 10mA.

dblStartCurrent = Val(textStartCurrent)
If dblStartCurrent < 0.0001 Then dblStartCurrent = 0.0001
If dblStartCurrent > 0.25 Then dblStartCurrent = 0.25
If EnableTest = True Then dblStartCurrent = 0.001
textStartCurrent.Text = dblStartCurrent



'The final current value of the sweep is limited in this program to
'300mA.  This value can be increased up to the limitations of the 2420
'or 3A.  Here the value is limited to protect the specific model of
'laser diode that is being tested.  Also, the final current values is
'adjusted to ensure that the sweep if from lower values to higher
'values.  This supports the dL/dI algorithms, etc.

dblStopCurrent = Val(textStopCurrent)
If (dblStopCurrent - dblStartCurrent) < 0.01 Then dblStopCurrent = dblStartCurrent + 0.01
If dblStopCurrent > 1# Then dblStopCurrent = 1#
textStopCurrent.Text = dblStopCurrent




'Here the value of the step size is checked.  To support dL/dI algorithm,
'the step is adjusted to provide at least 10 steps in the sweep.

dblStepCurrent = Val(textStepCurrent)
If dblStepCurrent > ((dblStopCurrent - dblStartCurrent) / 10) Then dblStepCurrent = (dblStopCurrent - dblStartCurrent) / 10
textStepCurrent = dblStepCurrent



'Here the number of steps in the sweep is calculated given start, stop,
'and step current values.  If the number of steps exceed 1000, then the
'number of steps is clamped to 1000 and the current step value is
'calculated to based on (stop-start)/1000.

intSteps = Int(1.01 + (dblStopCurrent - dblStartCurrent) / dblStepCurrent)
If intSteps > 1000 Then
    intSteps = 1000
    dblStepCurrent = (dblStopCurrent - dblStartCurrent) / 1000
    textStepCurrent = dblStepCurrent
End If
textSteps.Text = intSteps

DoEvents    'update display

End Sub

Private Sub mnuExit_Click()
    Unload frmLIVDemo
End Sub

Public Sub Form_Unload(Cancel As Integer)
    Cancel = MsgBox("Exit?", 20, "Exit Verify")         'Confirm exit
'    If Cancel = 6 Then
'        Quit = True
'    Else
'        Quit = False
'    End If
If Cancel = 6 Then              'Quit application was chosen, close all potentially open forms
    
    End                         'Stop program execution
End If

If Cancel = 7 Then
    
  Form_Load
  
End If

End Sub

Function EnterIB(AdrCV As Integer) As String
    Dim temp As String
    Dim length As Integer
    Dim status As Integer
    
    Call enter(temp, 1024, length, AdrCV, status)
    If status <> 0 Then Stop
    EnterIB = Left$(temp, length)
End Function


Private Sub mnuSaveAs_Click()
    Dim i As Integer
    Dim str24xxIRange As String
    Dim str24xxVRange As String
      
    ' Set CancelError is True
    CommonDialog1.CancelError = True
    On Error GoTo ErrHandler
    ' Set flags
    CommonDialog1.Flags = cdlOFNHideReadOnly
    ' Set filters
    CommonDialog1.Filter = "CSV Files (*.CSV)|*.csv"
    ' Specify default filter
    CommonDialog1.FilterIndex = 1
    ' Display the Open dialog box
    CommonDialog1.ShowSave
    ' Display name of selected file
  
    Call send(intKth2420%, ":sour:curr:rang?", intStatus)
    str24xxIRange = EnterIB(intKth2420%)
    
    Call send(intKth2420%, ":sens:volt:rang?", intStatus)
    str24xxVRange = EnterIB(intKth2420%)
  
    Open CommonDialog1.FileName For Output As #1
    Print #1, Date, ",", Time
    Print #1, txtComments
    Print #1, "24xx settings:"
    Print #1, "NPLC = ,", frmLIVDemo.comboNPLC, ",Src Delay = ,", CSng(frmLIVDemo.txtSourceDelay)
    Print #1, "Start I = ,", CSng(frmLIVDemo.textStartCurrent), ",Step I = ,", CSng(frmLIVDemo.textStepCurrent), ",Stop I = ,", CSng(frmLIVDemo.textStopCurrent)
    Print #1, "I Range = ,", str24xxIRange, ",V Range = ,", str24xxVRange
    
    Print #1, "2500 settings:"
    Print #1, "NPLC = ,", frmLIVDemo.comboNPLC
    Print #1, "Ch1 I Range = ,", CSng(frmLIVDemo.textN1CurrRange), ",Ch1 V Bias = ,", CSng(frmLIVDemo.textN1Bias), ", Ch1 I Range = ,", CSng(frmLIVDemo.textN1CurrRange)
    Print #1, "Ch2 I Range = ,", CSng(frmLIVDemo.textN2CurrRange), ",Ch2 V Bias = ,", CSng(frmLIVDemo.textN2Bias), ", Ch2 I Range = ,", CSng(frmLIVDemo.textN2CurrRange)
    
    Print #1,
    Print #1, "LD Curr,LD Volt, PD1 Curr, PD2 Curr, PD1 deriv, PD2 deriv"
    
    For i = 1 To intSteps
        strData = dblArray(intLDCurrent, i) & ","
        strData = strData & dblArray(intLDVoltage, i) & ","
        strData = strData & dblArray(intPDCurrent, i) / 1000 & ","
        strData = strData & dblArray(intBSDCurrent, i) / 4000000 & ","
        If i > 1 Then
            strData = strData & (dblArray(intPDCurrent, i) - dblArray(intPDCurrent, i - 1)) / (1000 * CSng(frmLIVDemo.textStepCurrent)) & ","
            strData = strData & (dblArray(intBSDCurrent, i) - dblArray(intBSDCurrent, i - 1)) / (4000000 * CSng(frmLIVDemo.textStepCurrent))
        Else
            strData = strData & 0 & ","
            strData = strData & 0
        End If
        Print #1, strData
    Next i
    Close #1
  Exit Sub
  
ErrHandler:
    'User pressed the Cancel button
End Sub

